///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	This file contains the texture-related exported structures.
 *	\file		FLX_AddTexture.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __FLX_ADDTEXTURE_H__
#define __FLX_ADDTEXTURE_H__

	//! The texture information class.
	class TextureDescriptor : public ObjectDescriptor
	{
		public:
		// Constructor / Destructor
										TextureDescriptor();
		virtual							~TextureDescriptor();

						TextureCrop		mCValues;						//!< Cropping values
						TextureMatrix	mTMtx;							//!< Texture matrix

		// Following fields are only valid if TexnameOnly is false in the ExportSettings structure.
						udword			mWidth;							//!< Texture's width
						udword			mHeight;						//!< Texture's height
						ubyte*			mPixels;						//!< Texture in R,G,B,A order. (always contains Alpha)
						bool			mHasAlpha;						//!< True => Alpha is valid.
		// Texture can be quantized
						ubyte*			mQuantized;						//!< Color indices
						ubyte*			mPalette;						//!< RGB palette (Alpha not available)
	};

#endif // __FLX_ADDTEXTURE_H__
